var docObj = app.activeDocument;

// レイヤー作成
function layObj(name) {
    var layer;
    try {
        layer = docObj.layers.getByName(name.text);//既存レイヤー名を取得
    } catch (e) {//在しない場合は新規レイヤーを作成
        layer = docObj.layers.add();
        layer.name = name.text;
    }
    return layer;
}



// レジストレーションスウォッチを安全に取得
function getColor(){
 var regSwatch = null;//値がない
 var targetColor;

    try{     
    // スウォッチを検索
        for (var i = 0; i < docObj.swatches.length; i++) {
            if (docObj.swatches[i].name === "[レジストレーション]") {
                regSwatch = docObj.swatches[i];
                break;
            }
        }
        // カラーを決定
        if (regSwatch) {
            targetColor = regSwatch.color;
        } else {
            // 代替カラー（CMYK 100%）
            targetColor = new CMYKColor();
            targetColor.cyan = 100;
            targetColor.magenta = 100;
            targetColor.yellow = 100;
            targetColor.black = 100;
        }
    } catch (e) {}
    return targetColor;
}

// 線描画
function drawLine(startPoint, middlePoint, endPoint) {
    var line = docObj.pathItems.add();
    line.setEntirePath([startPoint, middlePoint, endPoint]);
    line.filled = false;
    line.strokeWidth = 0.425;
    line.strokeColor = getColor();
    return line;
}

//線の単位を取得
function getStrokeUnits() {
    try {
        // 線単位のキーは "strokeUnits"
        var strokeUnitCode = app.preferences.getIntegerPreference("strokeUnits");

        // コードをわかりやすい名前に変換
        var strokeUnitName;
        switch (strokeUnitCode) {
           case 0: strokeUnitName = "in"; break;
            case 1: strokeUnitName = "mm"; break;
            case 2: strokeUnitName = "pt"; break;
            case 3: strokeUnitName = "pc"; break;
            case 4: strokeUnitName = "cm"; break;
            case 5: strokeUnitName = "Q"; break;
            case 6: strokeUnitName = "px"; break;
            default: strokeUnitName = "不明";
        }
        return strokeUnitName;

    } catch (e) {
        alert("線単位の取得中にエラーが発生しました: " + e.message);
        return null;
    }
}

// 単位変換
function point(num) {
    var objUV = new UnitValue(num, getStrokeUnits());
    return objUV.as("pt");
}

function os(size) {
    return size * 2;
}

// UIパネル設定
var dialog = new Window("dialog", "トリムマークとオフセット");

// ガイドオフセットパネル
var guidePanel = dialog.add("panel", undefined, "オフセット");
guidePanel.orientation = "column";
guidePanel.alignChildren = "left";
guidePanel.margins = 10;

var checkBox1 = guidePanel.add("checkbox", undefined, "オフセットを作成");

var offsetGroup = guidePanel.add("group");
offsetGroup.add("statictext", undefined, "オフセット値：");
var offSet = offsetGroup.add("edittext", undefined, "10");
offSet.characters = 5;
offsetGroup.add("statictext", undefined, getStrokeUnits());

var layerGroup1 = guidePanel.add("group");
layerGroup1.add("statictext", undefined, "レイヤー名：");
var layerName1 = layerGroup1.add("edittext", undefined, "offset");
layerName1.characters = 10;

// トリムマークパネル
var trimPanel = dialog.add("panel", undefined, "トリムマーク");
trimPanel.orientation = "column";
trimPanel.alignChildren = "left";
trimPanel.margins = 10;

var checkBox2 = trimPanel.add("checkbox", undefined, "トリムマークの作成");

var layerGroup2 = trimPanel.add("group");
layerGroup2.add("statictext", undefined, "レイヤー名：");
var layerName2 = layerGroup2.add("edittext", undefined, "trimMark");
layerName2.characters = 10;

// アートボード選択パネル
var artboardPanel = dialog.add("panel", undefined, "アートボード選択");
artboardPanel.orientation = "column";
artboardPanel.alignChildren = "left";
artboardPanel.margins = 10;

var artboardOptions = artboardPanel.add("dropdownlist", undefined, ["全てのアートボード", "選択中のアートボード"]);
artboardOptions.selection = 0; // デフォルトは「全てのアートボード」

// ボタン
var buttonGroup = dialog.add("group");
buttonGroup.alignment = "center";
var btnOK = buttonGroup.add("button", undefined, "OK", { name: "ok" });
var btnCancel = buttonGroup.add("button", undefined, "Cancel", { name: "cancel" });

// 初期値
offSet.active = true;
checkBox1.value = true;
checkBox2.value = true;

// キャンセル処理
btnCancel.onClick = function () {
    dialog.close();
};

// OK処理
btnOK.onClick = function () {
    dialog.close();

    var artboardsToProcess = [];
    if (artboardOptions.selection.index === 0) {
        // 全てのアートボード
        for (var i = 0; i < docObj.artboards.length; i++) {
            artboardsToProcess.push(i);
        }
    } else {
        // 選択中のアートボード
        artboardsToProcess.push(docObj.artboards.getActiveArtboardIndex());
    }

    for (var i = 0; i < artboardsToProcess.length; i++) {
        var abIndex = artboardsToProcess[i];
        docObj.artboards.setActiveArtboardIndex(abIndex);
        app.coordinateSystem = CoordinateSystem.ARTBOARDCOORDINATESYSTEM;

        var rect = docObj.artboards[abIndex].artboardRect;
        var left = rect[0], top = rect[1], right = rect[2], bottom = rect[3];
        var width = right - left;
        var height = top - bottom;
        var centerX = left + width / 2;
        var centerY = top - height / 2;

        if (checkBox1.value) {
            var offsetLayer = layObj(layerName1);
            docObj.activeLayer = offsetLayer;
            offsetLayer.locked = false;

            var figures;
            try {
                figures = eval(offSet.text);
                if (isNaN(figures)) throw new Error("NaN");
            } catch (e) {
                alert("オフセット値が無効です。数値を入力してください。");
                return;
            }

            var rectObj = docObj.activeLayer.pathItems.rectangle(
                top - point(figures),
                left + point(figures),
                width - os(point(figures)),
                height - os(point(figures))
            );
            rectObj.guides = true;
            offsetLayer.locked = true;
        }

        if (checkBox2.value) {
            var trimLayer = layObj(layerName2);
            docObj.activeLayer = trimLayer;
            trimLayer.locked = false;

            var trimGroup = docObj.groupItems.add();
            var lines = [];

            // 四隅
            lines.push(drawLine([left - point(12), top], [left - point(3), top], [left - point(3), top + point(12)]));
            lines.push(drawLine([left - point(12), top + point(3)], [left, top + point(3)], [left, top + point(12)]));
            lines.push(drawLine([right + point(12), top], [right + point(3), top], [right + point(3), top + point(12)]));
            lines.push(drawLine([right + point(12), top + point(3)], [right, top + point(3)], [right, top + point(12)]));
            lines.push(drawLine([left - point(12), bottom], [left - point(3), bottom], [left - point(3), bottom - point(12)]));
            lines.push(drawLine([left - point(12), bottom - point(3)], [left, bottom - point(3)], [left, bottom - point(12)]));
            lines.push(drawLine([right + point(12), bottom], [right + point(3), bottom], [right + point(3), bottom - point(12)]));
            lines.push(drawLine([right + point(12), bottom - point(3)], [right, bottom - point(3)], [right, bottom - point(12)]));

            // 中央上下
            lines.push(drawLine([centerX - point(12.7), top + point(6.35)], [centerX, top + point(6.35)], [centerX + point(12.7), top + point(6.35)]));
            lines.push(drawLine([centerX, top + point(4.233)], [centerX, top + point(6.35)], [centerX, top + point(12.7)]));
            lines.push(drawLine([centerX - point(12.7), bottom - point(6.35)], [centerX, bottom - point(6.35)], [centerX + point(12.7), bottom - point(6.35)]));
            lines.push(drawLine([centerX, bottom - point(4.233)], [centerX, bottom - point(6.35)], [centerX, bottom - point(12.7)]));

            // 中央左右
            lines.push(drawLine([left - point(6.35), centerY + point(12.7)], [left - point(6.35), centerY], [left - point(6.35), centerY - point(12.7)]));
            lines.push(drawLine([left - point(4.233), centerY], [left - point(6.35), centerY], [left - point(12.7), centerY]));
            lines.push(drawLine([right + point(6.35), centerY + point(12.7)], [right + point(6.35), centerY], [right + point(6.35), centerY - point(12.7)]));
            lines.push(drawLine([right + point(4.233), centerY], [right + point(6.35), centerY], [right + point(12.7), centerY]));

            for (var j = 0; j < lines.length; j++) {
                lines[j].move(trimGroup, ElementPlacement.PLACEATEND);
            }

            trimLayer.locked = true;
        }
    }
};

dialog.center();
dialog.show();
