﻿// 配列の並び替え　ここから
function sortLayers(layers, order) {
    // 配列を並び替えるための関数
    layers.sort(function(a, b) {
        if (order === 'asc') {
            // 昇順に並び替える場合
            return a - b;
        } else if (order === 'desc') {
            // 降順に並び替える場合
            return b - a;
        }
    });
}
// 配列の並び替え　ここまで

// レイヤーの読み込み　ここから
if (app.documents.length === 0) {
    alert("ドキュメントが開いていません。");
} else {
    var doc = app.activeDocument; // アクティブなドキュメントを取得
    var selLay = []; // 選択されたレイヤーを格納する配列

    for (var i = 0; i < doc.layers.length; i++) {
        if (!doc.layers[i].locked) {
            selLay.push(i); // ロックされていないレイヤーのインデックスを配列に追加
            doc.layers[i].visible = false;  // レイヤーを非表示にする
        }
    }
// レイヤーの読み込み　ここまで
    if (selLay.length === 0) {
        alert("出力可能なレイヤーがありません。");
    } else{
        // ユーザーインターフェースを作成　ここから
        var dialog = new Window('dialog', 'レイヤー別出力'); // ダイアログウィンドウを作成
        dialog.orientation = 'column'; // ダイアログのレイアウトを縦方向に設定
        dialog.alignChildren = 'left'; // 子要素を左揃えに設定

        // 昇順・降順のラジオボタンを追加　ここから
        var orderGroup = dialog.add('group'); // グループを追加
        orderGroup.add('statictext', undefined, '出力順序:'); // ラベルを追加
        var ascRadio = orderGroup.add('radiobutton', undefined, '昇順'); // 昇順ラジオボタンを追加
        var descRadio = orderGroup.add('radiobutton', undefined, '降順'); // 降順ラジオボタンを追加
        ascRadio.value = true; // デフォルトで昇順を選択


        // OKボタンとキャンセルボタンを追加　ここから
        var buttonGroup = dialog.add('group'); // ボタングループを追加
        buttonGroup.alignment = 'right'; // ボタンを右揃えに設定
        var okButton = buttonGroup.add('button', undefined, 'OK', {name: 'ok'}); // OKボタンを追加
        var cancelButton = buttonGroup.add('button', undefined, 'キャンセル', {name: 'cancel'}); // キャンセルボタンを追加


        // OKボタンが押されたときの処理　ここから
        okButton.onClick = function() {
            var order = ascRadio.value ? 'asc' : 'desc'; // 選択された順序を取得
            sortLayers(selLay, order); // 配列を並び替え
            dialog.close(); // ダイアログを閉じる

        //出力可能　ここから
            doc.layers[selLay[0]].visible = true; // 最初のレイヤーを可視化
            app.executeMenuCommand("Print"); // プリンタメニューを起動
            doc.layers[selLay[0]].visible = false; // レイヤーを再度非表示

            $.sleep(700); // 700ミリ秒待機

            var continuePrint = confirm("印刷を続行しますか？"); // 印刷を続行するか確認
            if (continuePrint) {
                for(var i = 1; i < selLay.length; i++){
                    var num = selLay[i];
                    doc.layers[num].visible = true; // レイヤーを表示
                    var options = new PrintOptions(); // 印刷オプションを作成
                    var printJobOptions = new PrintJobOptions(); // 印刷ジョブオプションを作成
                    printJobOptions.designation = PrintArtworkDesignation.VISIBLELAYERS; // 表示中のレイヤーを印刷
                    options.jobOptions = printJobOptions;
                    try {
                        doc.print(options); // 印刷
                    } catch (e) {
                        alert("印刷中にエラーが発生しました: " + e.message);
                    }
                    doc.layers[num].visible = false; // レイヤーを非表示
                }
            } else {
                alert("印刷がキャンセルされました。"); // 印刷がキャンセルされたことを通知
            }
        };
        // OKボタンが押されたときの処理　ここまで

        // キャンセルボタンが押されたときの処理　ここから
        cancelButton.onClick = function() {
            dialog.close(); // ダイアログを閉じる
        };
        // キャンセルボタンが押されたときの処理　ここまで

        // ダイアログを表示
        dialog.show();
    }
}